package com.bxm.adx.service.common.sifter.task;

import java.util.Map;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.enums.TaskTypeEnum;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.api.adapter.wake.WakeAdapterHandle;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;

/**
 * 唤醒许可<br/>
 *
 * @author kerry.jiang
 * @date 2020/7/21 16:55
 */
@Component
@Slf4j
public class TaskWakeAllowSifter extends TaskAbstractSifter {

    @Autowired
    private WakeAdapterHandle wakeAdapterHandle;

    @Override
    public boolean filter(Context<TaskData> context) {

        //唤醒许可限制
        if(filterWakeAllow(context)){
            return true;
        }

        return false;
    }

    /**
     * 填充唤醒拉活许可
     */
    private boolean filterWakeAllow(Context<TaskData> context) {
        TaskData data = context.getData();
        TaskCache taskCache = data.getTaskCache();
        if(!Objects.equals(taskCache.getType(), TaskTypeEnum.SILENCE_WAKE.getId())){
            //不是静默唤醒任务
            return false;
        }
        Integer wakeCheckApi = taskCache.getWakeCheckApi();
        if(null == wakeCheckApi || wakeCheckApi < 1){
            return false;
        }
        Map<Integer, Boolean> mapWakeAllow = data.getMapWakeAllow();
        Boolean allow = mapWakeAllow.get(wakeCheckApi);
        if(null != allow){//已获取过值
            if(!allow){//不许可
                super.addReason(context, "API不许可");
                return true;
            }
            return false;
        }

        TaskInfoRequest request = data.getRequest();
        allow = wakeAdapterHandle.isWakeUser(taskCache.getWakeCheckApi(), request);
        mapWakeAllow.put(wakeCheckApi, allow);
        if(!allow){//不许可
            super.addReason(context, "API不许可");
            return true;
        }
        return false;
    }
}
