package com.bxm.adx.service.facade;

import java.util.List;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.facade.model.dev.SdkInitCache;
import com.bxm.adx.facade.model.dev.UserProfile;
import com.bxm.adx.facade.service.UserService;
import com.bxm.adx.service.common.util.DevHelper;
import com.bxm.adx.service.service.DevService;

import lombok.extern.slf4j.Slf4j;

/**
 * 用户信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/9/21 14:52
 */
@RestController
@Slf4j
public class UserServiceImpl implements UserService {

    @Autowired
    private DevService devService;

    @Override
    public UserProfile getUser(@RequestBody DevRequest request) {
        UserProfile user = new UserProfile();
        user.setUid(DevHelper.getUid(request));
        return user;
    }

    @Override
    public SdkInitCache getSdkInit(@RequestBody DevRequest request) {
        String uid = DevHelper.getUid(request);
        return getSdkInitByUid(uid);
    }

    @Override
    public SdkInitCache getSdkInitByUid(String uid) {
        return devService.getSdkInitByUid(uid);
    }

    @Override
    public List<String> getInstalledList(@RequestBody DevRequest request) {
        if(!Objects.equals(request.getOs(), DevOsEnum.ANDROID.getId())){
            return null;
        }
        String devNo = DevHelper.getUid(request);
        return getInstalledListByUid(devNo);
    }

    @Override
    public List<String> getInstalledListByUid(String uid) {
        return devService.getInstalledListByUid(uid);
    }
}
