package com.bxm.adx.service.service;

import java.util.List;

import com.bxm.adx.facade.model.dev.SdkInitCache;

/**
 * 设备信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/9/22 10:08
 */
public interface DevService {

    /**
     * 获取SDK初始化信息<br/>
     *
     * @param uid @see com.bxm.adx.service.common.util.DevHelper.getUid()
     * @return com.bxm.adx.facade.model.dev.SdkInitCache
     */
    SdkInitCache getSdkInitByUid(String uid);

    /**
     * 获取SDK初始化时的已安装APP包名列表<br/>
     * 仅支持安卓<br/>
     *
     * @param uid @see com.bxm.adx.service.common.util.DevHelper.getUid()
     * @return java.util.List<java.lang.String>
     */
    List<String> getInstalledListByUid(String uid);
}
