package com.bxm.adx.service.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.model.dev.SdkInitCache;
import com.bxm.adx.service.service.DevService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;

/**
 * 设备信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/9/22 10:10
 */
@Service
public class DevServiceImpl implements DevService {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Override
    public SdkInitCache getSdkInitByUid(String uid) {
        KeyGenerator keyGenerator = AdxKeyGenerator.Device.getInitInfo(uid);
        return fetcher.fetch(keyGenerator, SdkInitCache.class);
    }

    @Override
    public List<String> getInstalledListByUid(String uid) {
        KeyGenerator keyGenerator = AdxKeyGenerator.Device.getInitInstalledList(uid);
        return fetcher.fetch(keyGenerator, List.class);
    }
}
