/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.api.tencent;

import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.service.common.api.adapter.wake.WakeAdapter;
import com.bxm.adx.service.common.api.adapter.wake.WakeCheckApiEnum;
import com.bxm.adx.service.common.api.adapter.wake.WakeRequest;
import com.bxm.adx.service.common.api.adapter.wake.WakeResponse;
import com.bxm.adx.service.common.api.tencent.TencentNewsApi;
import com.bxm.adx.service.common.api.tencent.TencentNewsWakeRequest;
import com.bxm.adx.service.common.api.tencent.TencentNewsWakeResponse;
import com.bxm.adx.service.common.autoconfigure.config.ApiConfig;
import com.bxm.adx.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.adx.service.common.util.DevHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
public class TencentWakeAdapter
extends TencentNewsApi
implements WakeAdapter {
    private static final String DEF_MARK = "lahuo_new";
    @Resource(name="wakeRestTemplate")
    private RestTemplate restTemplate;
    private ApiConfig config;

    public TencentWakeAdapter(ApplicationGlobalConfig globalConfig) {
        super(globalConfig.getTencentNews().getUrl());
        this.config = globalConfig.getTencentNews();
    }

    @Override
    public WakeCheckApiEnum getAdapterId() {
        return WakeCheckApiEnum.TENCENT_NEWS;
    }

    @Override
    public WakeResponse getWakeUser(WakeRequest request) {
        HashMap<String, String> mapMd5 = new HashMap<String, String>();
        TencentNewsWakeRequest rq = this.of(request, mapMd5);
        TencentNewsWakeResponse rs = this.getWakeUser(this.restTemplate, rq);
        return this.of(rs, mapMd5);
    }

    private TencentNewsWakeRequest of(WakeRequest request, Map<String, String> mapMd5) {
        TencentNewsWakeRequest rq = new TencentNewsWakeRequest();
        rq.setSource(this.config.getId());
        rq.setKey(this.config.getKey());
        rq.setMark(DEF_MARK);
        String devNo = DevHelper.getUid(DevRequest.builder().os(request.getOs()).imei(request.getImei()).anid(request.getAnid()).idfa(request.getIdfa()).build());
        String md5 = DigestUtils.md5Hex((String)devNo);
        mapMd5.put(md5, devNo);
        rq.setIds(Arrays.asList(md5));
        return rq;
    }

    private WakeResponse of(TencentNewsWakeResponse rs, Map<String, String> mapMd5) {
        WakeResponse response = new WakeResponse();
        if (null == rs || !rs.sucess() || CollectionUtils.isEmpty(rs.getData())) {
            return response;
        }
        List<TencentNewsWakeResponse.User> users = rs.getData();
        ArrayList<String> devNos = new ArrayList<String>(users.size());
        response.setDevNos(devNos);
        for (TencentNewsWakeResponse.User user : users) {
            devNos.add(mapMd5.get(user.getId()));
        }
        return response;
    }
}

