/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.pushable;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.facade.rule.task.TaskOfRules;
import com.bxm.adx.service.common.convert.TaskConvert;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TaskOpenedPushable
implements Pushable {
    private static final Logger log = LoggerFactory.getLogger(TaskOpenedPushable.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public void push(Map<String, Object> parameters, byte[] data) {
        TaskOfRules rules = (TaskOfRules)JsonHelper.convert((byte[])data, TaskOfRules.class);
        String taskId = String.valueOf(rules.getId());
        KeyGenerator keyGenerator = AdxKeyGenerator.Task.getOpenedList();
        if (rules.isOpened()) {
            TaskCache cache = TaskConvert.ofOpened(rules);
            this.updater.hupdate(keyGenerator, taskId, (Object)cache);
        } else {
            this.updater.hremove(keyGenerator, new String[]{taskId});
        }
    }
}

