/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.pushable;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.Rule;
import com.bxm.adx.facade.rule.task.TaskAppRuleSo;
import com.bxm.adx.facade.rule.task.TaskDeviceBrandRuleSo;
import com.bxm.adx.facade.rule.task.TaskFrequencyRuleSo;
import com.bxm.adx.facade.rule.task.TaskOfRules;
import com.bxm.adx.facade.rule.task.TaskPositionRuleSo;
import com.bxm.adx.facade.rule.task.TaskTimeSlotRuleSo;
import com.bxm.adx.service.common.convert.TaskConvert;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.HashUpdating;
import com.bxm.warcar.cache.push.JSONObjectPushable;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@CachePush(value="TASK")
public class TaskPushable
extends JSONObjectPushable<TaskOfRules>
implements HashUpdating<TaskOfRules> {
    private static final Logger log = LoggerFactory.getLogger(TaskPushable.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier(value="taskRegionPushable")
    private Pushable taskRegionPushable;
    @Autowired
    @Qualifier(value="taskAppPushable")
    private Pushable taskAppPushable;
    @Autowired
    @Qualifier(value="taskPositionPushable")
    private Pushable taskPositionPushable;
    @Autowired
    @Qualifier(value="taskFrequencyPushable")
    private Pushable taskFrequencyPushable;
    @Autowired
    @Qualifier(value="taskOpenedPushable")
    private Pushable taskOpenedPushable;
    @Autowired
    @Qualifier(value="taskDeviceBrandPushable")
    private Pushable taskDeviceBrandPushable;
    @Autowired
    @Qualifier(value="taskTimeSlotPushable")
    private Pushable taskTimeSlotPushable;

    public TaskPushable() {
        super((Converter)new Converter<TaskOfRules>(){

            public Object convert(TaskOfRules object) {
                return TaskConvert.of(object);
            }
        });
    }

    protected Class<TaskOfRules> getClsType() {
        return TaskOfRules.class;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public String getField(Map<String, Object> parameters, TaskOfRules object) {
        return String.valueOf(object.getId());
    }

    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
        return AdxKeyGenerator.Task.getAllList();
    }

    protected void beforeUpdate(Map<String, Object> parameters, byte[] data, TaskOfRules object) {
        Rule region = object.getRegion();
        this.taskRegionPushable.push(parameters, null == region ? null : JsonHelper.convert2bytes((Object)region));
        Rule app = object.getApps();
        this.taskAppPushable.push(parameters, null == app ? null : JsonHelper.convert2bytes((Object)app));
        Rule position = object.getPosition();
        this.taskPositionPushable.push(parameters, null == position ? null : JsonHelper.convert2bytes((Object)position));
        Rule frequencys = object.getFrequencys();
        this.taskFrequencyPushable.push(parameters, null == frequencys ? null : JsonHelper.convert2bytes((Object)frequencys));
        Rule deviceBrands = object.getDeviceBrands();
        this.taskDeviceBrandPushable.push(parameters, null == deviceBrands ? null : JsonHelper.convert2bytes((Object)deviceBrands));
        Rule timeSlots = object.getTimeSlots();
        this.taskTimeSlotPushable.push(parameters, null == timeSlots ? null : JsonHelper.convert2bytes((Object)timeSlots));
        this.taskOpenedPushable.push(parameters, data);
    }

    @Bean
    public Pushable taskAppPushable() {
        return new JSONObjectPushable<TaskAppRuleSo>(){

            protected Class<TaskAppRuleSo> getClsType() {
                return TaskAppRuleSo.class;
            }

            public Updater getUpdater() {
                return TaskPushable.this.updater;
            }

            protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
                Object taskId = parameters.get("taskId");
                return AdxKeyGenerator.Task.getAppRule((Long)TypeHelper.castToLong((Object)taskId));
            }
        };
    }

    @Bean
    public Pushable taskPositionPushable() {
        return new JSONObjectPushable<TaskPositionRuleSo>(){

            protected Class<TaskPositionRuleSo> getClsType() {
                return TaskPositionRuleSo.class;
            }

            public Updater getUpdater() {
                return TaskPushable.this.updater;
            }

            protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
                Object taskId = parameters.get("taskId");
                return AdxKeyGenerator.Task.getPositionRule((Long)TypeHelper.castToLong((Object)taskId));
            }
        };
    }

    @Bean
    public Pushable taskFrequencyPushable() {
        return new JSONObjectPushable<TaskFrequencyRuleSo>(){

            protected Class<TaskFrequencyRuleSo> getClsType() {
                return TaskFrequencyRuleSo.class;
            }

            public Updater getUpdater() {
                return TaskPushable.this.updater;
            }

            protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
                Object taskId = parameters.get("taskId");
                return AdxKeyGenerator.Task.getFrequencyRule((Long)TypeHelper.castToLong((Object)taskId));
            }
        };
    }

    @Bean
    public Pushable taskDeviceBrandPushable() {
        return new JSONObjectPushable<TaskDeviceBrandRuleSo>(){

            protected Class<TaskDeviceBrandRuleSo> getClsType() {
                return TaskDeviceBrandRuleSo.class;
            }

            public Updater getUpdater() {
                return TaskPushable.this.updater;
            }

            protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
                Object taskId = parameters.get("taskId");
                return AdxKeyGenerator.Task.getDeviceBrandRule((Long)TypeHelper.castToLong((Object)taskId));
            }
        };
    }

    @Bean
    public Pushable taskTimeSlotPushable() {
        return new JSONObjectPushable<TaskTimeSlotRuleSo>(){

            protected Class<TaskTimeSlotRuleSo> getClsType() {
                return TaskTimeSlotRuleSo.class;
            }

            public Updater getUpdater() {
                return TaskPushable.this.updater;
            }

            protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
                Object taskId = parameters.get("taskId");
                return AdxKeyGenerator.Task.getTimeSlotRule((Long)TypeHelper.castToLong((Object)taskId));
            }
        };
    }
}

