/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter;

import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.sifter.AbstractSifter;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ClassUtils;

public class SifterMeter
implements MeterBinder,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(SifterMeter.class);
    private final Map<Class, Timer> timer = Maps.newHashMap();
    private Iterable<AbstractSifter> sifters;
    private MeterRegistry registry;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.sifters = event.getApplicationContext().getBeansOfType(AbstractSifter.class).values();
        this.initTimers();
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    public Timer getTimer(Interceptor interceptor) {
        return this.timer.get(ClassUtils.getUserClass(interceptor.getClass()));
    }

    private void initTimers() {
        for (AbstractSifter sifter : this.sifters) {
            Class clazz = ClassUtils.getUserClass(sifter.getClass());
            Timer timer = Timer.builder((String)"task.sifter").tags(new String[]{"name", clazz.getName()}).register(this.registry);
            this.timer.put(clazz, timer);
            if (!log.isInfoEnabled()) continue;
            log.info("Bind filter {} to MeterRegistry", (Object)clazz);
        }
    }
}

