/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskAppRuleSo;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class TaskAppSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskAppSifter.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public boolean filter(Context<TaskData> context) {
        if (StringUtils.isEmpty((String)((TaskData)context.getData()).getRequest().getAppId())) {
            return false;
        }
        this.fillApp(context);
        return this.filterApp(context);
    }

    private boolean filterApp(Context<TaskData> context) {
        String appId = ((TaskData)context.getData()).getRequest().getAppId();
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        TaskAppRuleSo rule = ((TaskData)context.getData()).getMapAppRule().get(data.getId());
        if (null == rule || CollectionUtils.isEmpty((Collection)rule.getApps())) {
            return false;
        }
        boolean blackList = rule.isBlackList();
        Set list = rule.getApps();
        if (blackList) {
            if (list.contains(appId)) {
                super.addReason(context, "\u5728\u5f00\u53d1\u8005\u5e94\u7528\u9ed1\u540d\u5355");
                return true;
            }
        } else if (!list.contains(appId)) {
            super.addReason(context, "\u4e0d\u5728\u5f00\u53d1\u8005\u5e94\u7528\u767d\u540d\u5355");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillApp(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        if (Boolean.TRUE.equals(data.getFlagApp())) {
            return;
        }
        List<Long> ids = super.getIds(context);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HashMap<Long, TaskAppRuleSo> mapAppRule = new HashMap<Long, TaskAppRuleSo>();
        data.setFlagApp(Boolean.TRUE);
        data.setMapAppRule(mapAppRule);
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<String>> mapAppRuleRs = new HashMap<Long, Response<String>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapAppRuleRs.put(id, (Response<String>)pipeline.get(AdxKeyGenerator.Task.getAppRule((Long)id).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("fillApp error: ids={},e={}", ids, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        this.fillApp(mapAppRule, mapAppRuleRs);
    }

    private void fillApp(Map<Long, TaskAppRuleSo> mapAppRule, Map<Long, Response<String>> mapAppRuleRs) {
        Set<Long> keySet = mapAppRuleRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapAppRuleRs.get(id);
            String str = (String)strRs.get();
            if (StringUtils.isBlank((String)str)) continue;
            mapAppRule.put(id, (TaskAppRuleSo)JSON.parseObject((String)str, TaskAppRuleSo.class));
        }
    }
}

