/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class TaskRegionSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskRegionSifter.class);
    private static final String DEFAULT_CODE = "000000";
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public boolean filter(Context<TaskData> context) {
        this.fillRegion(context);
        return this.filterRegion(context);
    }

    private boolean filterRegion(Context<TaskData> context) {
        TaskInfoRequest request = ((TaskData)context.getData()).getRequest();
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        Set<String> regionCodes = ((TaskData)context.getData()).getMapRegion().get(data.getId());
        if (CollectionUtils.isEmpty(regionCodes)) {
            return false;
        }
        String regionCode = StringUtils.defaultIfEmpty((String)request.getIprst().getRegioncode(), (String)DEFAULT_CODE);
        boolean flagSelf = regionCodes.contains(regionCode);
        boolean flagProvince = regionCodes.contains(this.getProvinceCode(regionCode));
        if (!flagSelf && !flagProvince) {
            super.addReason(context, "\u5730\u57df\u9650\u5236");
            return true;
        }
        return false;
    }

    private String getProvinceCode(String regionCode) {
        return StringUtils.rightPad((String)StringUtils.left((String)regionCode, (int)2), (int)6, (String)"0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillRegion(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        if (Boolean.TRUE.equals(data.getFlagRegion())) {
            return;
        }
        List<Long> ids = super.getIds(context);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HashMap<Long, Set<String>> mapRegion = new HashMap<Long, Set<String>>();
        data.setFlagRegion(Boolean.TRUE);
        data.setMapRegion(mapRegion);
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<String>> mapRegionRs = new HashMap<Long, Response<String>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapRegionRs.put(id, (Response<String>)pipeline.get(AdxKeyGenerator.Task.getRegionList((Long)id).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("fillRegion error: ids={},e={}", ids, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        this.fillRegion(mapRegion, mapRegionRs);
    }

    private void fillRegion(Map<Long, Set<String>> mapRegion, Map<Long, Response<String>> mapRegionRs) {
        Set<Long> keySet = mapRegionRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapRegionRs.get(id);
            String str = (String)strRs.get();
            if (StringUtils.isBlank((String)str)) continue;
            mapRegion.put(id, (Set<String>)JSON.parseObject((String)str, Set.class));
        }
    }
}

