/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.facade;

import com.bxm.adx.facade.constant.enums.AppPlatformTypeEnum;
import com.bxm.adx.facade.constant.enums.TaskTypeEnum;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.model.position.Position;
import com.bxm.adx.facade.model.task.TaskCounter;
import com.bxm.adx.facade.model.task.TaskInfo;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.app.App;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.facade.service.TaskService;
import com.bxm.adx.service.common.sifter.task.TaskSifterForListChain;
import com.bxm.adx.service.common.sifter.task.TaskSifterForSingleChain;
import com.bxm.adx.service.integration.TaskCounterIntegration;
import com.bxm.adx.service.service.IpService;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@RestController
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final Pattern pattern = Pattern.compile(".*/task/+countInfo.*");
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private IpService ipService;
    @Autowired
    private TaskSifterForSingleChain taskSifterForSingleChain;
    @Autowired
    private TaskSifterForListChain taskSifterForListChain;
    @Autowired
    private TaskCounterIntegration taskCounterIntegration;

    public TaskInfo getTask(@RequestBody TaskInfoRequest request) {
        Position position;
        if (log.isDebugEnabled()) {
            log.debug("request={}", (Object)request);
        }
        if (null == (position = (Position)this.fetcher.fetch(AdxKeyGenerator.Position.getInfo((String)request.getPositionId()), Position.class))) {
            log.warn("position is null, positionId={}", (Object)request.getPositionId());
            return null;
        }
        request.setAppId(position.getAppId());
        if (!this.checkApp(request)) {
            return null;
        }
        String bidId = this.idGenerator.next();
        this.taskCounterIntegration.counterRequest(request, bidId);
        List<TaskCache> taskCacheList = this.getOpenedList();
        if (CollectionUtils.isEmpty(taskCacheList)) {
            if (log.isDebugEnabled()) {
                log.debug("taskCacheList is empty!");
            }
            return null;
        }
        this.autoFillTaskInfoRequest(request);
        TaskCache taskCache = this.taskSifterForSingleChain.filter(request, taskCacheList);
        if (null == taskCache) {
            return null;
        }
        this.taskCounterIntegration.counterResponse(request, bidId, taskCache.getId());
        return this.getTaskInfo(request, taskCache, bidId);
    }

    public List<TaskInfo> getTasks(@RequestBody TaskInfoRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("request={}", (Object)request);
        }
        if (!this.checkApp(request)) {
            return null;
        }
        List<TaskCache> taskCacheList = this.getOpenedList();
        if (CollectionUtils.isEmpty(taskCacheList)) {
            if (log.isDebugEnabled()) {
                log.debug("taskCacheList is empty!");
            }
            this.taskCounterIntegration.counterRequest(request, this.idGenerator.next());
            return null;
        }
        this.autoFillTaskInfoRequest(request);
        List<TaskCache> taskCaches = this.taskSifterForListChain.filter(request, taskCacheList);
        if (CollectionUtils.isEmpty(taskCaches)) {
            this.taskCounterIntegration.counterRequest(request, this.idGenerator.next());
            return null;
        }
        return this.getTaskInfos(request, taskCaches);
    }

    private List<TaskInfo> getTaskInfos(TaskInfoRequest request, List<TaskCache> taskCaches) {
        ArrayList<TaskInfo> resps = new ArrayList<TaskInfo>();
        String bidId = null;
        for (TaskCache taskCache : taskCaches) {
            bidId = this.idGenerator.next();
            if (Objects.equals(1, request.getTrackerType())) {
                if (Objects.equals(TaskTypeEnum.VIEW_CLICK.getId(), taskCache.getType())) {
                    this.doTracker(request, resps, taskCache, bidId);
                }
            } else {
                this.doTracker(request, resps, taskCache, bidId);
            }
            resps.add(this.getTaskInfo(request, taskCache, bidId));
        }
        return resps;
    }

    private void doTracker(TaskInfoRequest request, List<TaskInfo> resps, TaskCache taskCache, String bidId) {
        this.taskCounterIntegration.counterRequest(request, bidId);
        this.taskCounterIntegration.counterResponse(request, bidId, taskCache.getId());
    }

    private boolean checkApp(@RequestBody TaskInfoRequest request) {
        App app = (App)this.fetcher.fetch(AdxKeyGenerator.App.getInfo((String)request.getAppId()), App.class);
        if (null == app) {
            KeyGenerator keyGenerator = AdxKeyGenerator.App.getInfoByCustom((String)request.getAppId(), (Integer)AppPlatformTypeEnum.convert((Integer)request.getOs()).getId());
            app = (App)this.fetcher.fetch(keyGenerator, App.class);
            if (null == app) {
                log.warn("app is null, appId={}", (Object)request.getAppId());
                return false;
            }
            request.setAppId(app.getAppId());
        }
        if (!app.isOpenTask()) {
            log.debug("app not open task, appId={}", (Object)request.getAppId());
            return false;
        }
        return true;
    }

    private void autoFillTaskInfoRequest(TaskInfoRequest request) {
        request.setIprst(this.ipService.analyze(request.getIp()));
    }

    private List<TaskCache> getOpenedList() {
        Map taskCacheMap = this.fetcher.hfetchall(AdxKeyGenerator.Task.getOpenedList(), null, TaskCache.class);
        if (MapUtils.isEmpty((Map)taskCacheMap)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(taskCacheMap.values());
    }

    private TaskInfo getTaskInfo(TaskInfoRequest request, TaskCache taskCache, String bidId) {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setTaskId(taskCache.getId());
        taskInfo.setTaskType(taskCache.getType());
        taskInfo.setWakePkn(taskCache.getPackageName());
        taskInfo.setWakeDeepUrl(taskCache.getJumpProtocol());
        taskInfo.setViewClkMax(taskCache.getViewClickInterval());
        if (null == taskCache.getWakeUpToDesktop() || taskCache.getWakeUpToDesktop() < 1) {
            taskInfo.setWakeBackMax(Integer.valueOf(3));
        } else {
            taskInfo.setWakeBackMax(taskCache.getWakeUpToDesktop());
        }
        taskInfo.setAcquireTrackers(this.getTrackers(request, bidId, taskCache.getId(), taskCache.getAcquireMonitorUrl()));
        taskInfo.setViewTrackers(this.getTrackers(request, bidId, taskCache.getId(), taskCache.getViewMonitorUrl()));
        taskInfo.setClickTrackers(this.getTrackers(request, bidId, taskCache.getId(), taskCache.getClickMonitorUrl()));
        taskInfo.setReadyTrackers(this.getTrackers(request, bidId, taskCache.getId(), taskCache.getReadyMonitorUrl()));
        taskInfo.setWakeTrackers(this.getTrackers(request, bidId, taskCache.getId(), taskCache.getWakeUpMonitorUrl()));
        taskInfo.setSucceedTrackers(this.getTrackers(request, bidId, taskCache.getId(), taskCache.getWakeSucceedMonitorUrl()));
        return taskInfo;
    }

    private List<String> getTrackers(TaskInfoRequest request, String bidId, Long taskId, String monitorUrl) {
        if (StringUtils.isBlank((CharSequence)monitorUrl)) {
            return null;
        }
        String[] urlArr = monitorUrl.split(",");
        ArrayList<String> urls = new ArrayList<String>();
        for (String url : urlArr) {
            if (!pattern.matcher(url).find()) continue;
            if (url.indexOf("?") > -1) {
                urls.add(StringUtils.join((Object[])new Serializable[]{url, "&bidid=", bidId, "&appid=", request.getAppId(), "&taskid=", taskId}));
                continue;
            }
            urls.add(StringUtils.join((Object[])new Serializable[]{url, "?bidid=", bidId, "&appid=", request.getAppId(), "&taskid=", taskId}));
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskCounter> getByIds(String idsStr) {
        if (StringUtils.isBlank((CharSequence)idsStr)) {
            return null;
        }
        Date today = new Date();
        String dmy = DateHelper.format((Date)today, (String)"yyyyMMdd");
        String[] ids = idsStr.split(",");
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<Map<String, String>>> mapRsMap = new HashMap<Long, Response<Map<String, String>>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (String idStr : ids) {
                Long id = Long.valueOf(idStr);
                mapRsMap.put(id, (Response<Map<String, String>>)pipeline.hgetAll(AdxKeyGenerator.Task.getCounter((Long)id, (String)dmy).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("getByIds error: idsStr={},e={}", (Object)idsStr, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return this.getTaskCounters(mapRsMap);
    }

    private List<TaskCounter> getTaskCounters(Map<Long, Response<Map<String, String>>> mapRsMap) {
        ArrayList<TaskCounter> resps = new ArrayList<TaskCounter>();
        Set<Long> keySet = mapRsMap.keySet();
        for (Long id : keySet) {
            Response<Map<String, String>> mapRs = mapRsMap.get(id);
            Map map = (Map)mapRs.get();
            if (MapUtils.isEmpty((Map)map)) continue;
            TaskCounter counter = new TaskCounter();
            resps.add(counter);
            counter.setId(id);
            String acquires = (String)map.get("ACQUIRES");
            counter.setTodayAcquires(Long.valueOf(StringUtils.isBlank((CharSequence)acquires) ? 0L : Long.valueOf(acquires)));
            String views = (String)map.get("VIEWS");
            counter.setTodayViews(Long.valueOf(StringUtils.isBlank((CharSequence)views) ? 0L : Long.valueOf(views)));
            String clicks = (String)map.get("CLICKS");
            counter.setTodayClicks(Long.valueOf(StringUtils.isBlank((CharSequence)clicks) ? 0L : Long.valueOf(clicks)));
            String readyWakes = (String)map.get("READY_WAKES");
            counter.setTodayReadyWakes(Long.valueOf(StringUtils.isBlank((CharSequence)readyWakes) ? 0L : Long.valueOf(readyWakes)));
            String wakes = (String)map.get("WAKES");
            counter.setTodayWakes(Long.valueOf(StringUtils.isBlank((CharSequence)wakes) ? 0L : Long.valueOf(wakes)));
            String succeedWakes = (String)map.get("SUCCEED_WAKES");
            counter.setTodaySucceedWakes(Long.valueOf(StringUtils.isBlank((CharSequence)succeedWakes) ? 0L : Long.valueOf(succeedWakes)));
        }
        return resps;
    }
}

