/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.facade;

import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.facade.model.dev.SdkInitCache;
import com.bxm.adx.facade.model.dev.UserProfile;
import com.bxm.adx.facade.service.UserService;
import com.bxm.adx.service.common.util.DevHelper;
import com.bxm.adx.service.service.DevService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private DevService devService;

    public UserProfile getUser(@RequestBody DevRequest request) {
        UserProfile user = new UserProfile();
        user.setUid(DevHelper.getUid(request));
        return user;
    }

    public SdkInitCache getSdkInit(@RequestBody DevRequest request) {
        String uid = DevHelper.getUid(request);
        return this.getSdkInitByUid(uid);
    }

    public SdkInitCache getSdkInitByUid(String uid) {
        return this.devService.getSdkInitByUid(uid);
    }

    public List<String> getInstalledList(@RequestBody DevRequest request) {
        if (!Objects.equals(request.getOs(), DevOsEnum.ANDROID.getId())) {
            return null;
        }
        String devNo = DevHelper.getUid(request);
        return this.getInstalledListByUid(devNo);
    }

    public List<String> getInstalledListByUid(String uid) {
        return this.devService.getInstalledListByUid(uid);
    }
}

