/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.integration;

import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.facade.model.TaskCounterDTO;
import com.bxm.adxcounter.facade.service.TaskCounterService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskCounterIntegration {
    private static final Logger log = LoggerFactory.getLogger(TaskCounterIntegration.class);
    private static final String DEF_TAG_ID = "task";
    private static final String DEF_DSP_ID = "0";
    private static final String DEF_OS = "0";
    @Resource
    private TaskCounterService taskCounterService;

    public void counterRequest(TaskInfoRequest request, String bidId) {
        TaskCounterDTO counter = this.getTaskCounterInfo(AdxMtEnum._207, request, bidId);
        try {
            this.taskCounterService.counter(counter);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u8bf7\u6c42\u57cb\u70b9\u5f02\u5e38:", (Throwable)e);
        }
    }

    public void counterResponse(TaskInfoRequest request, String bidId, Long taskId) {
        TaskCounterDTO counter = this.getTaskCounterInfo(AdxMtEnum._208, request, bidId);
        try {
            counter.setTaskid(taskId.toString());
            this.taskCounterService.counter(counter);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u54cd\u5e94\u57cb\u70b9\u5f02\u5e38:", (Throwable)e);
        }
    }

    private TaskCounterDTO getTaskCounterInfo(AdxMtEnum adxMtEnum, TaskInfoRequest request, String bidId) {
        TaskCounterDTO counter = new TaskCounterDTO();
        counter.setT(String.valueOf(System.currentTimeMillis()));
        counter.setMt(Integer.valueOf(adxMtEnum.getOriginal()));
        counter.setIp(request.getIp());
        counter.setUa(request.getUa());
        counter.setOs(request.getOs() == null ? DEF_OS : request.getOs().toString());
        counter.setImei(request.getImei());
        counter.setIdfa(request.getIdfa());
        counter.setAppid(request.getAppId());
        counter.setTagid(DEF_TAG_ID);
        counter.setDspid("0");
        counter.setBidid(bidId);
        return counter;
    }
}

