/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.api.tencent;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.service.common.api.tencent.TencentNewsWakeRequest;
import com.bxm.adx.service.common.api.tencent.TencentNewsWakeResponse;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class TencentNewsApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(TencentNewsApi.class);
    private static String SOURCE = "source";
    private static String MARK = "mark";
    private static String IDS = "ids";
    private static String TIMESTAMP = "timestamp";
    private static String SIGN = "sign";
    private static HttpHeaders headers = new HttpHeaders();
    protected String api_url;

    public TencentNewsApi(String api_url) {
        this.api_url = api_url;
    }

    public TencentNewsWakeResponse getWakeUser(RestTemplate restTemplate, TencentNewsWakeRequest request) {
        MultiValueMap<String, String> postParameters = this.getParameters(request);
        HttpEntity httpEntity = new HttpEntity(postParameters, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = restTemplate.postForEntity(this.api_url, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (ResourceAccessException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("getWakeUser timeout:paramJson={}", (Object)JsonHelper.convert((Object)request));
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("getWakeUser error: paramJson={},e={}", (Object)JsonHelper.convert((Object)request), (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            return null;
        }
        HttpStatus httpStatus = responseEntity.getStatusCode();
        if (HttpStatus.OK == httpStatus) {
            TencentNewsWakeResponse response = (TencentNewsWakeResponse)JsonHelper.convert((String)((String)responseEntity.getBody()), TencentNewsWakeResponse.class);
            if (null == response || !response.sucess()) {
                LOGGER.warn("getWakeUser warn: paramJson={}, response={}", (Object)JsonHelper.convert((Object)request), (Object)response);
            }
            return response;
        }
        LOGGER.warn("getWakeUser warn: httpStatus={}, paramJson={}", (Object)httpStatus.value(), (Object)JsonHelper.convert((Object)request));
        return null;
    }

    private MultiValueMap<String, String> getParameters(TencentNewsWakeRequest request) {
        LinkedMultiValueMap postParameters = new LinkedMultiValueMap();
        String timestamp = "" + System.currentTimeMillis() / 1000L;
        String sign = DigestUtils.md5Hex((String)StringUtils.join((Object[])new String[]{request.getSource(), timestamp, request.getKey()}));
        postParameters.add((Object)SOURCE, (Object)request.getSource());
        postParameters.add((Object)MARK, (Object)request.getMark());
        postParameters.add((Object)IDS, (Object)JSON.toJSONString(request.getIds()));
        postParameters.add((Object)TIMESTAMP, (Object)timestamp);
        postParameters.add((Object)SIGN, (Object)sign);
        return postParameters;
    }

    static {
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
    }
}

