/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.pushable;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.app.App;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.JSONObjectPushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@CachePush(value="APP")
public class AppPushable
extends JSONObjectPushable<App> {
    private static final Logger log = LoggerFactory.getLogger(AppPushable.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public AppPushable() {
        super((Converter)new Converter<App>(){

            public Object convert(App object) {
                return object;
            }
        });
    }

    protected Class<App> getClsType() {
        return App.class;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
        Object appId = parameters.get("appId");
        return AdxKeyGenerator.App.getInfo((String)TypeHelper.castToString((Object)appId));
    }

    protected void beforeUpdate(Map<String, Object> parameters, byte[] data, App object) {
        String customAppId = TypeHelper.castToString((Object)parameters.get("customAppId"));
        Integer platformType = TypeHelper.castToInt((Object)parameters.get("platformType"));
        if (StringUtils.isNotEmpty((String)customAppId)) {
            KeyGenerator keyGenerator = AdxKeyGenerator.App.getInfoByCustom((String)customAppId, (Integer)platformType);
            this.updater.remove(keyGenerator);
            if (null != object) {
                this.updater.update(keyGenerator, (Object)object);
            }
        }
    }
}

