/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.pushable;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskRegionRuleSo;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TaskRegionPushable
implements Pushable {
    private static final Logger log = LoggerFactory.getLogger(TaskRegionPushable.class);
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug("Starting refresh cache...");
        }
        long start = System.currentTimeMillis();
        Object taskIdObj = parameters.get("taskId");
        if (null == taskIdObj) {
            return;
        }
        Long taskId = Long.valueOf(taskIdObj.toString());
        KeyGenerator keyGenerator = AdxKeyGenerator.Task.getRegionList((Long)taskId);
        this.updater.remove(keyGenerator);
        this.updateRegion(data, keyGenerator);
        if (log.isInfoEnabled()) {
            log.info("Refreshed cache in {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    protected void updateRegion(byte[] data, KeyGenerator keyGenerator) {
        if (ArrayUtils.isEmpty((byte[])data)) {
            return;
        }
        TaskRegionRuleSo rule = (TaskRegionRuleSo)JsonHelper.convert((byte[])data, TaskRegionRuleSo.class);
        List entries = rule.getEntries();
        if (CollectionUtils.isEmpty((Collection)entries)) {
            return;
        }
        this.updater.update(keyGenerator, (Object)entries.toArray(new String[0]));
    }
}

