/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.bxm.adx.facade.constant.enums.TaskTypeEnum;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskChainData;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.integration.sifter.Context;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskGlobalSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskGlobalSifter.class);

    public boolean filter(Context<TaskData> context) {
        return this.filterFrequency(context);
    }

    private boolean filterFrequency(Context<TaskData> context) {
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        if (!Objects.equals(data.getType(), TaskTypeEnum.SILENCE_WAKE.getId())) {
            return false;
        }
        TaskChainData chainData = ((TaskData)context.getData()).getChainData();
        Map<String, String> mapConf = chainData.getMapGlobalConfig();
        Map<String, String> mapDevCounterToday = chainData.getMapDevCounterToday();
        if (MapUtils.isEmpty(mapConf) || MapUtils.isEmpty(mapDevCounterToday)) {
            return false;
        }
        String maximumTimesForDayStr = mapConf.get("maximum_times_for_day");
        if (StringUtils.isNotBlank((String)maximumTimesForDayStr)) {
            Long wakes = NumberUtils.toLong((String)mapDevCounterToday.get("WAKES"), (long)0L);
            Long maximumTimesForDay = Long.valueOf(maximumTimesForDayStr);
            if (wakes >= maximumTimesForDay) {
                super.addReason(context, "\u5355\u8bbe\u5907\u5f53\u65e5\u6700\u5927\u5524\u9192\u6570\u9650\u5236");
                return true;
            }
        }
        return false;
    }
}

