/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adx.service.common.sifter.task;

import com.alibaba.fastjson.JSON;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.model.position.Position;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.adx.facade.rule.task.TaskPositionRuleSo;
import com.bxm.adx.service.common.sifter.task.TaskAbstractSifter;
import com.bxm.adx.service.common.sifter.task.TaskData;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Component
public class TaskPositionSifter
extends TaskAbstractSifter {
    private static final Logger log = LoggerFactory.getLogger(TaskPositionSifter.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    public boolean filter(Context<TaskData> context) {
        this.fillPosition(context);
        return this.filterPosition(context);
    }

    private boolean filterPosition(Context<TaskData> context) {
        String positionId = ((TaskData)context.getData()).getRequest().getPositionId();
        String appId = ((TaskData)context.getData()).getRequest().getAppId();
        TaskCache data = ((TaskData)context.getData()).getTaskCache();
        TaskPositionRuleSo rule = ((TaskData)context.getData()).getMapPositionRule().get(data.getId());
        if (null == rule || CollectionUtils.isEmpty((Collection)rule.getPositions())) {
            return false;
        }
        boolean blackList = rule.isBlackList();
        Set list = rule.getPositions();
        if (StringUtils.isNotEmpty((String)positionId)) {
            if (blackList) {
                if (list.contains(positionId)) {
                    super.addReason(context, "\u5728\u5e7f\u544a\u4f4d\u9ed1\u540d\u5355");
                    return true;
                }
            } else if (!list.contains(positionId)) {
                super.addReason(context, "\u4e0d\u5728\u5e7f\u544a\u4f4d\u767d\u540d\u5355");
                return true;
            }
        } else if (StringUtils.isNotEmpty((String)appId)) {
            Set<String> appIds = this.getAppIds(list);
            if (blackList) {
                if (appIds.contains(appId)) {
                    super.addReason(context, "\u5728\u5f00\u53d1\u8005\u5e94\u7528\u9ed1\u540d\u5355");
                    return true;
                }
            } else if (!appIds.contains(appId)) {
                super.addReason(context, "\u4e0d\u5728\u5f00\u53d1\u8005\u5e94\u7528\u767d\u540d\u5355");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getAppIds(Set<String> positionIds) {
        HashSet<String> appIds = new HashSet<String>();
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        ArrayList<Response> listAppRs = new ArrayList<Response>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (String positionId : positionIds) {
                listAppRs.add(pipeline.get(AdxKeyGenerator.Position.getInfo((String)positionId).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("getAppIds error: positionIds={},e={}", positionIds, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        for (Response strRs : listAppRs) {
            Position position;
            String str = (String)strRs.get();
            if (StringUtils.isBlank((String)str) || null == (position = (Position)JSON.parseObject((String)str, Position.class))) continue;
            appIds.add(position.getAppId());
        }
        return appIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPosition(Context<TaskData> context) {
        TaskData data = (TaskData)context.getData();
        if (Boolean.TRUE.equals(data.getFlagPosition())) {
            return;
        }
        List<Long> ids = super.getIds(context);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HashMap<Long, TaskPositionRuleSo> mapPositionRule = new HashMap<Long, TaskPositionRuleSo>();
        data.setFlagPosition(Boolean.TRUE);
        data.setMapPositionRule(mapPositionRule);
        JedisPool jedisPool = (JedisPool)this.fetcher.getClientOriginal();
        Jedis jedis = null;
        HashMap<Long, Response<String>> mapPositionRuleRs = new HashMap<Long, Response<String>>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapPositionRuleRs.put(id, (Response<String>)pipeline.get(AdxKeyGenerator.Task.getPositionRule((Long)id).generateKey()));
            }
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("fillPosition error: ids={},e={}", ids, (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        this.fillPosition(mapPositionRule, mapPositionRuleRs);
    }

    private void fillPosition(Map<Long, TaskPositionRuleSo> mapPositionRule, Map<Long, Response<String>> mapPositionRuleRs) {
        Set<Long> keySet = mapPositionRuleRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapPositionRuleRs.get(id);
            String str = (String)strRs.get();
            if (StringUtils.isBlank((String)str)) continue;
            mapPositionRule.put(id, (TaskPositionRuleSo)JSON.parseObject((String)str, TaskPositionRuleSo.class));
        }
    }
}

