package com.bxm.adx.service.common.api.adapter.wake;

/**
 * 唤醒检查接口<br/>
 *
 * @author kerry.jiang
 * @date 2020/7/21 15:07
 */
public enum WakeCheckApiEnum {

    /**
     * 无
     */
    NONE(0, "无"),
    /**
     * 腾讯新闻
     */
    TENCENT_NEWS(1, "腾讯新闻"),
    ;

    private int value;
    private String name;

    WakeCheckApiEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static WakeCheckApiEnum get(int value) {
        WakeCheckApiEnum[] enums = values();
        for (WakeCheckApiEnum temp : enums) {
            if (temp.value == value) {
                return temp;
            }
        }
        return NONE;
    }

}
