package com.bxm.adx.service.common.api.tencent;

import java.io.Serializable;
import java.util.List;

import lombok.Data;
import lombok.ToString;

/**
 * 唤醒查询响应-腾讯新闻<br/>
 *
 * @author kerry.jiang
 * @date 2020/7/21 11:05
 */
@Data
@ToString
public class  TencentNewsWakeResponse implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /** 成功代码 **/
    public final static String SUCCESS = "0";

    /**
     * 状态码
     */
    private String code;
    /**
     * 错误信息
     */
    private String msg;
    /**
     * 用户列表
     */
    private List<User> data;

    public boolean sucess(){
        return SUCCESS.equals(code);
    }

    @Data
    @ToString
    public static class User implements Serializable {

        /**
         * 用户ID
         */
        private String id;
        /**
         * 新闻ID
         */
        private String newsid;
    }
}
