package com.bxm.adx.service.common.api.tencent;

import javax.annotation.Resource;

import java.util.*;

import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.service.common.api.adapter.wake.WakeAdapter;
import com.bxm.adx.service.common.api.adapter.wake.WakeCheckApiEnum;
import com.bxm.adx.service.common.api.adapter.wake.WakeRequest;
import com.bxm.adx.service.common.api.adapter.wake.WakeResponse;
import com.bxm.adx.service.common.autoconfigure.config.ApiConfig;
import com.bxm.adx.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.adx.service.common.util.DevHelper;

@Configuration
public class TencentWakeAdapter extends TencentNewsApi implements WakeAdapter {

    /**
     * 默认用户分类
     */
    private final static String DEF_MARK = "lahuo_new";

    @Resource(name = "wakeRestTemplate")
    private RestTemplate restTemplate;

    private ApiConfig config;

    public TencentWakeAdapter(ApplicationGlobalConfig globalConfig) {
        super(globalConfig.getTencentNews().getUrl());
        this.config = globalConfig.getTencentNews();
    }

    @Override
    public WakeCheckApiEnum getAdapterId() {
        return WakeCheckApiEnum.TENCENT_NEWS;
    }

    @Override
    public WakeResponse getWakeUser(WakeRequest request) {
        Map<String, String> mapMd5 = new HashMap<>();
        TencentNewsWakeRequest rq = of(request, mapMd5);
        TencentNewsWakeResponse rs = getWakeUser(restTemplate, rq);
        return of(rs, mapMd5);
    }

    /**
     * 信息转换
     */
    private TencentNewsWakeRequest of(WakeRequest request, Map<String, String> mapMd5){
        TencentNewsWakeRequest rq = new TencentNewsWakeRequest();
        rq.setSource(config.getId());
        rq.setKey(config.getKey());
        rq.setMark(DEF_MARK);
        String devNo = DevHelper.getUid(DevRequest.builder()
                .os(request.getOs())
                .imei(request.getImei())
                .anid(request.getAnid())
                .idfa(request.getIdfa())
                .build());
        String md5 = DigestUtils.md5Hex(devNo);
        mapMd5.put(md5, devNo);
        rq.setIds(Arrays.asList(md5));
        return rq;
    }

    /**
     * 信息转换
     */
    private WakeResponse of(TencentNewsWakeResponse rs, Map<String, String> mapMd5){
        WakeResponse response = new WakeResponse();
        if(null == rs || !rs.sucess() || CollectionUtils.isEmpty(rs.getData())){
            return response;
        }
        List<TencentNewsWakeResponse.User> users = rs.getData();
        List<String> devNos = new ArrayList<>(users.size());
        response.setDevNos(devNos);
        for (TencentNewsWakeResponse.User user : users) {
            devNos.add(mapMd5.get(user.getId()));
        }
        return response;
    }
}
