package com.bxm.adx.service.common.autoconfigure;

import org.springframework.context.annotation.Configuration;

import com.bxm.warcar.integration.pushable.CachePushableBus;
import com.bxm.warcar.integration.pushable.message.CachePushableMessageListener;
import com.bxm.warcar.mq.autoconfigure.Subscriber;
import com.bxm.warcar.mq.autoconfigure.SubscriberWrapper;

/**
 * 自动装载缓存推送消费者<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 20:14
 */
@Configuration
public class CachePushableAutoConfiguration {

    /**
     * 缓存推送消费者
     */
    @Subscriber
    public class AdxPushableConsumer extends CachePushableMessageListener implements SubscriberWrapper {

        public AdxPushableConsumer(CachePushableBus cachePushableBus) {
            super("ADX_SERVICE_CACHE_PUSH", cachePushableBus);
        }

        @Override
        public String getConsumerId() {
            return getClass().getName();
        }
    }
}
