package com.bxm.adx.service.common.pushable;

import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.app.App;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.JSONObjectPushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.TypeHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 推送接收器-开发者应用信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 11:19
 */
@Component
@CachePush("APP")
@Slf4j
public class AppPushable extends JSONObjectPushable<App> {

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    public AppPushable() {
        super(new Converter<App>() {
            @Override
            public Object convert(App object) {
                return object;
            }
        });
    }

    @Override
    protected Class<App> getClsType() {
        return App.class;
    }

    @Override
    public Updater getUpdater() {
        return updater;
    }

    @Override
    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
        Object appId = parameters.get(CachePushableFields.APP_ID);
        return AdxKeyGenerator.App.getInfo(TypeHelper.castToString(appId));
    }

    @Override
    protected void beforeUpdate(Map<String, Object> parameters, byte[] data, App object) {
        String customAppId = TypeHelper.castToString(parameters.get(CachePushableFields.CUSTOM_APP_ID));
        Integer platformType = TypeHelper.castToInt(parameters.get(CachePushableFields.PLATFORM_TYPE));
        if(StringUtils.isNotEmpty(customAppId)){
            KeyGenerator keyGenerator = AdxKeyGenerator.App.getInfoByCustom(customAppId, platformType);
            updater.remove(keyGenerator);
            if (null != object) {
                updater.update(keyGenerator, object);
            }
        }
    }
}
