package com.bxm.adx.service.common.pushable;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.config.Config;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.HashUpdating;
import com.bxm.warcar.cache.push.JSONObjectPushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;

import lombok.extern.slf4j.Slf4j;

/**
 * 全局配置<br/>
 *
 * @author kerry.jiang
 * @since 2020/7/9 17:11
 */
@Component
@CachePush("CONFIG")
@Slf4j
public class ConfigPushable extends JSONObjectPushable<Config> implements HashUpdating<Config> {

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    public ConfigPushable() {
        super(new Converter<Config>() {
            @Override
            public Object convert(Config object) {
                return object.getConfigValue();
            }
        });
    }

    @Override
    protected Class<Config> getClsType() {
        return Config.class;
    }

    @Override
    public Updater getUpdater() {
        return updater;
    }

    @Override
    public String getField(Map<String, Object> parameters, Config object) {
        return object.getConfigKey();
    }

    @Override
    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
        return AdxKeyGenerator.getConfig();
    }

}
