package com.bxm.adx.service.common.pushable;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.mccms.facade.model.pushable.PositionInteractAppentranceRefCacheVO;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * Created by Arei on 2020/10/19.
 */
@Component
@CachePush(value = "POSITION_INTERACT_APPENTRANCE_REF")
@Slf4j
public class PositionInteractDaoImpl implements PositionInteractDao, Pushable {
    private final Fetcher fetcher;
    private final Updater updater;

    public PositionInteractDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug("POSITION_INTERACT_APPENTRANCE_REF");
        }
        PositionInteractAppentranceRefCacheVO cacheVO = JsonHelper.convert(data, PositionInteractAppentranceRefCacheVO.class);
        String positionId = cacheVO.getPositionId();
        updater.hupdate(AdxKeyGenerator.Position.getPositionInteract(), positionId, cacheVO);
    }
}
