package com.bxm.adx.service.common.pushable;

import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskRegionRuleSo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.utils.JsonHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 推送接收器-地域信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 19:21
 */
@Component
@Slf4j
public class TaskRegionPushable implements Pushable {

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug("Starting refresh cache...");
        }
        long start = System.currentTimeMillis();
        Object taskIdObj = parameters.get(CachePushableFields.TASK_ID);
        if (null == taskIdObj) {
            return;
        }
        Long taskId = Long.valueOf(taskIdObj.toString());
        KeyGenerator keyGenerator = AdxKeyGenerator.Task.getRegionList(taskId);
        
        // 删除区域定向数据
        updater.remove(keyGenerator);
        // 更新区域定向
        updateRegion(data, keyGenerator);
        if (log.isInfoEnabled()) {
            log.info("Refreshed cache in {} ms", (System.currentTimeMillis() - start));
        }
    }

    /**
     * 更新区域定向
     */
    protected void updateRegion(byte[] data, KeyGenerator keyGenerator) {
        if (ArrayUtils.isEmpty(data)) {
            return ;
        }
        TaskRegionRuleSo rule = JsonHelper.convert(data, TaskRegionRuleSo.class);
        List<String> entries = rule.getEntries();
        if (CollectionUtils.isEmpty(entries)) {
            return ;
        }
        updater.update(keyGenerator, entries.toArray(new String[]{}));
    }
}
