package com.bxm.adx.service.common.sifter;

import lombok.Data;

/**
 * 分批次取值<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/27 11:31
 */
@Data
public class BatchData implements java.io.Serializable {

    public static final long serialVersionUID = 422L;
    
    //---------------  分批取值 --------
    /**
     * 当前索引
     */
    private int index = -1;
    /**
     * 本批次开始位（索引）
     */
    private int start = 0;
    /**
     * 单批次最大数量,-1表示不分批
     */
    private int size = -1;
    //---------------  分批取值 end --------

    /**
     * 计数
     */
    public void count(){
        index ++;
        if(size < 1){
            return;
        }
        if(index == (start + size)){
            start += size;
            resetFlag();
        }
    }

    /**
     * 重置取值标识
     */
    public void resetFlag(){
    }
}
