package com.bxm.adx.service.common.sifter;

import java.util.ArrayList;
import java.util.List;

import com.bxm.warcar.integration.sifter.Context;

/**
 * 筛选者辅助类<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/27 10:51
 */
public class SifterHelper {

    /**
     * 获取需取值的ID列表<br/>
     * 不分批次<br/>
     * 
     * @param context
     * @param all
     * @return
     */
    public static List<?> getList(Context context, List<?> all){
        List ids = new ArrayList<>();
        all.forEach(id ->{
            //去除掉被其他过滤器过滤掉的ID
            if(!context.getMessage().getNoPassIdList().contains(id)){
                ids.add(id);
            }
        });
        return ids;
    }

    /**
     * 获取需取值的ID列表<br/>
     * 分批次<br/>
     *
     * @param context
     * @param all
     * @return
     */
    public static List<?> getList(Context context, BatchData batch, List<?> all){
        List subList = subList(batch, all);
        return getList(context, subList);
    }

    /**
     * 分批次
     */
    private static List<?> subList(BatchData batch, List<?> all){
        if(batch.getSize() < 1){
            return all;
        }
        int end = batch.getStart() + batch.getSize();
        if(end > all.size()){
            end = all.size();
        }
        
        return all.subList(batch.getStart(), end);
    }
}
