package com.bxm.adx.service.common.sifter.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.*;
import com.bxm.adx.service.common.sifter.BatchData;

import lombok.Data;

/**
 * 数据模型<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 20:40
 */
@Data
public class TaskData extends BatchData implements java.io.Serializable {
    
    public static final long serialVersionUID = 42L;

    /**
     * 请求参数
     */
    private TaskInfoRequest request;
    /**
     * 任务信息
     */
    private TaskCache taskCache;
    /**
     * 链填充数据
     */
    private TaskChainData chainData;


    //---------------  根据key判断是否取值 --------
    /**
     * 唤醒许可
     */
    private Map<Integer, Boolean> mapWakeAllow = new HashMap<>();
    //---------------  根据key判断是否取值 end --------


    //---------------  统计数取值标识 --------
    private Boolean flagCounter = Boolean.FALSE;
    /**
     * 总统计数
     */
    private Map<Long, Map<String, String>> mapCtTotal;
    /**
     * 今日统计数
     */
    private Map<Long, Map<String, String>> mapCtToday;
    //---------------  统计数取值标识 end --------


    //---------------  频次取值标识 --------
    private Boolean flagFrequency = Boolean.FALSE;
    /**
     * 今日当前设备统计数
     */
    private Map<Long, Map<String, String>> mapCtTodayDev;
    /**
     * 获取设备频次设置
     */
    private Map<Long, TaskFrequencyRuleSo> mapFreqRule;
    //---------------  频次取值标识 end --------


    //---------------  开发者应用取值标识 --------
    private Boolean flagApp = Boolean.FALSE;
    /**
     * 开发者应用黑白名单
     */
    private Map<Long, TaskAppRuleSo> mapAppRule;
    //---------------  开发者应用取值标识 end --------

    
    //---------------  广告位取值标识 --------
    private Boolean flagPosition = Boolean.FALSE;
    /**
     * 广告位黑白名单
     */
    private Map<Long, TaskPositionRuleSo> mapPositionRule;
    //---------------  广告位取值标识 end --------

    
    //---------------  地域取值标识 --------
    private Boolean flagRegion = Boolean.FALSE;
    /**
     * 支持的地域列表
     */
    private Map<Long, Set<String>> mapRegion;
    //---------------  地域取值标识 end --------

    
    //---------------  地域取值标识 --------
    private Boolean flagDeviceBrand = Boolean.FALSE;
    /**
     * 设备品牌黑白名单
     */
    private Map<Long, TaskDeviceBrandRuleSo> mapDeviceBrandRule;
    //---------------  地域取值标识 end --------


    //---------------  投放时段取值标识 --------
    private Boolean flagTimeSlot = Boolean.FALSE;
    /**
     * 投放时段
     */
    private Map<Long, TaskTimeSlotRuleSo> mapTimeSlotRule;
    //---------------  投放时段取值标识 end --------


    //---------------  时间间隔取值标识 --------
    private Boolean flagTimeInterval = Boolean.FALSE;
    /**
     * 时间间隔
     */
    private Map<Long, Long> mapTimeInterval;
    //---------------  时间间隔取值标识 end --------

    @Override
    public void resetFlag() {
        super.resetFlag();
        //重置分批取值的标识（不走分批的不用重置）
        this.flagCounter = Boolean.FALSE;
        this.flagFrequency = Boolean.FALSE;
        this.flagApp = Boolean.FALSE;
        this.flagPosition = Boolean.FALSE;
        this.flagRegion = Boolean.FALSE;
        this.flagDeviceBrand = Boolean.FALSE;
        this.flagTimeSlot = Boolean.FALSE;
    }
}
