package com.bxm.adx.service.common.sifter.task;

import java.util.Objects;

import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.enums.TaskTypeEnum;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;

/**
 * 系统定向<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 20:40
 */
@Component
@Slf4j
public class TaskOsSifter extends TaskAbstractSifter {

    @Override
    public boolean filter(Context<TaskData> context) {
        TaskData data = context.getData();
        TaskInfoRequest request = data.getRequest();
        TaskCache taskCache = data.getTaskCache();
        if(null == request.getOs()){
            super.addReason(context, "系统类型不明确");
            return true;
        }
        if(!Objects.equals(taskCache.getOs(), request.getOs())){
            super.addReason(context, "系统类型不匹配");
            return true;
        }
        if(taskCache.getType() == TaskTypeEnum.COPY.getId()) {//复制任务
            if (request.getOsv_14()) {// IOS版本14及以上不出复制任务
                super.addReason(context, "IOS版本14及以上不出复制任务");
                return true;
            }
        }
        return false;
    }
}
