package com.bxm.adx.service.common.sifter.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.redis.AdxKeyGenerator;
import com.bxm.adx.facade.rule.task.TaskCache;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.sifter.Context;

import lombok.extern.slf4j.Slf4j;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

/**
 * 间隔时间<br/>
 *
 * @author kerry.jiang
 * @date 2020/11/18 15:22
 */
@Component
@Slf4j
public class TaskTimeIntervalSifter extends TaskAbstractSifter {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    
    @Override
    public boolean filter(Context<TaskData> context) {
        //填充任务下发间隔时间
        fillTimeInterval(context);

        //下发时间间隔限制
        if(filterTimeInterval(context)){
            return true;
        }

        return false;
    }

    /**
     * 设备频次限制
     */
    private boolean filterTimeInterval(Context<TaskData> context) {
        TaskCache data = context.getData().getTaskCache();
        Long acqTime = context.getData().getMapTimeInterval().get(data.getId());
        if(null == acqTime || null == data.getTimeInterval()){
            return false;
        }
        Long currentTime = context.getData().getChainData().getToday().getTime();
        if((currentTime - acqTime) < (data.getTimeInterval() * 60 * 1000)){
            super.addReason(context, "同一任务下发间隔时间限制");
            return true;
        }
        return false;
    }

    /**
     * 填充任务下发间隔时间
     */
    private void fillTimeInterval(Context<TaskData> context) {
        TaskData data = context.getData();
        if(Boolean.TRUE.equals(data.getFlagTimeInterval())){//取值标识判断
            return ;
        }
        List<Long> ids = super.getIds(context);
        if(CollectionUtils.isEmpty(ids)){
            return;
        }

        Map<Long, Long> mapTimeInterval = new HashMap<>();
        data.setFlagTimeInterval(Boolean.TRUE);//取值标识变更
        data.setMapTimeInterval(mapTimeInterval);

        JedisPool jedisPool = (JedisPool)fetcher.getClientOriginal();
        Jedis jedis = null;
        Map<Long, Response<String>> mapTimeIntervalRs = new HashMap<>();
        try {
            jedis = jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            for (Long id : ids) {
                mapTimeIntervalRs.put(id, pipeline.get(AdxKeyGenerator.Counter.getTaskAcquireTime(id,
                        data.getRequest().getDevUid()).generateKey()));
            }
            pipeline.syncAndReturnAll();
        } catch (Exception e){
            log.error("fillTimeInterval error: ids={},e={}",
                    ids, ExceptionUtils.getFullStackTrace(e));
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }

        //填充任务下发间隔时间
        fillTimeInterval(mapTimeInterval, mapTimeIntervalRs);
    }

    /**
     * 填充任务下发间隔时间
     */
    private void fillTimeInterval(Map<Long, Long> mapTimeInterval, Map<Long, Response<String>> mapTimeIntervalRs) {
        Set<Long> keySet = mapTimeIntervalRs.keySet();
        for (Long id : keySet) {
            Response<String> strRs = mapTimeIntervalRs.get(id);
            String str = strRs.get();//单设备每日统计信息
            if(StringUtils.isEmpty(str)){
                continue;
            }
            mapTimeInterval.put(id, Long.valueOf(str));
        }
    }
}
