package com.bxm.adx.service.common.util;

import org.apache.commons.lang.StringUtils;

import com.bxm.adx.facade.constant.enums.DevOsEnum;
import com.bxm.adx.facade.model.dev.DevRequest;

/**
 * 设备<br/>
 *
 * @author kerry.jiang
 * @date 2020/9/21 11:34
 */
public final class DevHelper {

    /**
     * 获取uid<br/>
     *
     * @param dev 设备信息
     * @return java.lang.String
     */
    public static String getUid(DevRequest dev){
        DevOsEnum devOsEnum = null;
        if(null != dev.getOs()){
            devOsEnum = DevOsEnum.of(dev.getOs());
        }else{
            devOsEnum = DevOsEnum.of(dev.getOsStr());
        }
        return getUid(devOsEnum, dev);
    }

    /**
     * 获取uid<br/>
     *
     * @param devOsEnum 系统类型, 0:未知 1:安卓 2:IOS
     * @param dev 设备信息
     * @return java.lang.String
     */
    private static String getUid(DevOsEnum devOsEnum, DevRequest dev){
        String devNo = null;
        switch (devOsEnum){
            case ANDROID:
                devNo = getDevNo(dev.getImei(), dev.getImeiMd5(),
                        dev.getAnid(), dev.getAnidMd5(),
                        dev.getOaid());
                break;
            case IOS:
                devNo = getDevNo(dev.getIdfa(), dev.getIdfaMd5());
                break;
            default:
                devNo = getDevNo(dev.getImei(), dev.getImeiMd5(),
                        dev.getAnid(), dev.getAnidMd5(),
                        dev.getOaid(),
                        dev.getIdfa(), dev.getIdfaMd5());
                break;
        }
        return devNo;
    }

    /**
     * 按顺序获取第一个非空设备号<br/>
     */
    private static String getDevNo(String... devNos){
        for (String dev : devNos) {
            if(StringUtils.isNotBlank(dev)){
                return dev;
            }
        }
        return null;
    }
}
