package com.bxm.adx.service.controller;

import javax.servlet.http.HttpServletRequest;

import java.util.List;

import org.apache.http.protocol.HTTP;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adx.facade.model.task.TaskInfo;
import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adx.facade.service.TaskService;
import com.bxm.adx.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.web.util.Encrypted;
import com.bxm.warcar.web.util.EncryptedMessage;

/**
 * @author allen
 * @date 2020-11-19
 * @since 1.0
 */
@RestController
public class TaskController {

    private final TaskService taskService;
    private final ApplicationGlobalConfig config;

    public TaskController(TaskService taskService, ApplicationGlobalConfig config) {
        this.taskService = taskService;
        this.config = config;
    }

    /**
     * 广告位上的SDK获取耍呗任务列表（同一任务类型只出一个）
     * SDK3.1.1及以上开始使用该接口（加解密）
     */
    @PostMapping(value = "/sdk/tasks")
    @Encrypted(model = TaskInfoRequest.class, encryptResponseEntity = true)
    public ResponseEntity<List<TaskInfo>> tasksDES(@RequestBody EncryptedMessage<TaskInfoRequest> message,
                                                   HttpServletRequest request){
        if (!config.isEnableTask()) {
            return ResponseEntity.ok().build();
        }
        TaskInfoRequest taskRequest = message.getObject();
        //获取IP
        taskRequest.setIp(IpHelper.getIpFromHeader(request));
        //设置请求头内容
        taskRequest.setUa(request.getHeader(HTTP.USER_AGENT));
        return ResponseEntity.ok(taskService.getTasks(taskRequest));
    }
}
