package com.bxm.adx.service.facade;

import java.util.*;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.utils.StringHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 测试<br/>
 *
 * @author kerry.jiang
 * @date 2020/7/22 13:46
 */
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {

    /**
     * 模拟拉活接口
     */
    @RequestMapping(value = "/tencentNews",method = {RequestMethod.GET,RequestMethod.POST})
    public ResponseEntity<String> tencentNews(@RequestParam("ids") List<String> ids,
                                              @RequestParam("mode") String mode) {
        String[] arr = new String[]{"timeout","mismatch","pass"};
        String handleMode = null != mode ? mode : arr[new Random().nextInt(arr.length)];
        if(log.isDebugEnabled()){
            log.debug("------- handleMode={} -------", handleMode);
        }
        if("timeout".equals(handleMode)){//模拟超时
            try {
                Thread.sleep(1000);
            }catch (Exception e){
            }
        }else if("mismatch".equals(handleMode)){//模拟不匹配
            return ResponseEntity.ok("{\"msg\":\"\",\"code\":\"0\"}");
        }
        if(CollectionUtils.isEmpty(ids)){
            return ResponseEntity.ok("{\"msg\":\"\",\"code\":\"0\"}");
        }
        Map rs = new HashMap();
        rs.put("code", "0");
        rs.put("msg", "");
        List<Map> list = new ArrayList<>();
        rs.put("data", list);
        Map map = null;
        for (String id : ids) {
            map = new HashMap();
            list.add(map);
            map.put("id", id);
            map.put("newsid", StringHelper.uuid());
        }

        return ResponseEntity.ok(JSON.toJSONString(rs));
    }

}