package com.bxm.adx.service.integration;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.bxm.adx.facade.model.task.TaskInfoRequest;
import com.bxm.adxcounter.facade.constant.AdxMtEnum;
import com.bxm.adxcounter.facade.model.TaskCounterDTO;
import com.bxm.adxcounter.facade.service.TaskCounterService;

import lombok.extern.slf4j.Slf4j;

/**
 * 任务埋点<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/9 17:57
 */
@Slf4j
@Service
public class TaskCounterIntegration {

    /**
     * 默认广告位ID
     */
    private final static String DEF_TAG_ID = "task";
    /**
     * 默认dspId
     */
    private final static String DEF_DSP_ID = "0";
    /**
     * 默认os值
     */
    private final static String DEF_OS = "0";

    @Resource
    private TaskCounterService taskCounterService;

    /**
     * 任务请求
     */
    public void counterRequest(TaskInfoRequest request, String bidId) {
        TaskCounterDTO counter = getTaskCounterInfo(AdxMtEnum._207, request, bidId);
        try {
            taskCounterService.counter(counter);
        } catch (Exception e){
            log.error("任务请求埋点异常:", e);
        }
    }

    /**
     * 任务响应
     */
    public void counterResponse(TaskInfoRequest request, String bidId, Long taskId) {
        TaskCounterDTO counter = getTaskCounterInfo(AdxMtEnum._208, request, bidId);
        try {
            counter.setTaskid(taskId.toString());
            taskCounterService.counter(counter);
        } catch (Exception e){
            log.error("任务响应埋点异常:", e);
        }
    }

    /**
     * 获取任务埋点信息
     */
    private TaskCounterDTO getTaskCounterInfo(AdxMtEnum adxMtEnum, TaskInfoRequest request, String bidId) {
        TaskCounterDTO counter = new TaskCounterDTO();
        counter.setT(String.valueOf(System.currentTimeMillis()));
        counter.setMt(adxMtEnum.getOriginal());
        counter.setIp(request.getIp());
        counter.setUa(request.getUa());
        counter.setOs(request.getOs() == null ? DEF_OS : request.getOs().toString());
        counter.setImei(request.getImei());
        counter.setImei_md5(request.getImei_md5());
        counter.setAnid(request.getAnid());
        counter.setAnid_md5(request.getAnid_md5());
        counter.setOaid(request.getOaid());
        counter.setIdfa(request.getIdfa());
        counter.setIdfa_md5(request.getIdfa_md5());
        counter.setAppid(request.getAppId());
        counter.setTagid(DEF_TAG_ID);
        counter.setDspid(DEF_DSP_ID);
        counter.setBidid(bidId);
        return counter;
    }
}
