/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.util;

import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.web.util.EncryptContext;
import com.bxm.warcar.web.util.Encryptor;
import com.bxm.warcar.web.util.EncryptorFactory;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class TextEncrypted {
    private final EncryptorFactory encryptorFactory;

    public TextEncrypted(EncryptorFactory encryptorFactory) {
        this.encryptorFactory = encryptorFactory;
    }

    public String genGetUrl(Integer cipher, String url) {
        return this.genGetUrl(cipher, UUIDHelper.generate(), url);
    }

    public String genGetUrl(Integer cipher, String sign, String url) {
        String[] arr = url.split("\\?");
        if (arr.length != 2) {
            return url;
        }
        return this.genGetUrl(cipher, sign, arr[0], arr[1]);
    }

    public String genGetUrl(Integer cipher, String sign, String apiUrl, String plaintext) {
        String key = StringUtils.reverse((String)sign);
        Encryptor encryptor = this.encryptorFactory.get(cipher);
        if (null == encryptor) {
            throw new IllegalArgumentException("Not find Encryptor. cipher=" + cipher);
        }
        EncryptContext context = new EncryptContext();
        context.setContent(plaintext);
        context.setKey(key);
        String ciphertext = encryptor.encrypt(context);
        return StringUtils.join((Object[])new Serializable[]{apiUrl, Character.valueOf(apiUrl.indexOf(63) > -1 ? (char)'&' : '?'), "cipher=", cipher, "&sign=", sign, "&message=", ciphertext});
    }
}

