/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import com.netflix.servo.util.Preconditions;
import com.netflix.servo.util.ThreadFactories;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExpiringCache<K, V> {
    private final ConcurrentHashMap<K, Entry<V>> map;
    private final long expireAfterMs;
    private final Function<K, Entry<V>> entryGetter;
    private final Clock clock;
    private static final ScheduledExecutorService SERVICE = Executors.newSingleThreadScheduledExecutor(ThreadFactories.withName("expiringMap-%d"));

    public ExpiringCache(long expireAfterMs, Function<K, V> getter) {
        this(expireAfterMs, getter, TimeUnit.MINUTES.toMillis(1L), ClockWithOffset.INSTANCE);
    }

    public ExpiringCache(long expireAfterMs, Function<K, V> getter, long expirationFreqMs, Clock clock) {
        Preconditions.checkArgument(expireAfterMs > 0L, "expireAfterMs must be positive.");
        Preconditions.checkArgument(expirationFreqMs > 0L, "expirationFreqMs must be positive.");
        this.map = new ConcurrentHashMap();
        this.expireAfterMs = expireAfterMs;
        this.entryGetter = this.toEntry(getter);
        this.clock = clock;
        Runnable expirationJob = () -> {
            long tooOld = clock.now() - expireAfterMs;
            this.map.entrySet().stream().filter(entry -> ((Entry)entry.getValue()).accessTime < tooOld).forEach(entry -> this.map.remove(entry.getKey(), entry.getValue()));
        };
        SERVICE.scheduleWithFixedDelay(expirationJob, 1L, expirationFreqMs, TimeUnit.MILLISECONDS);
    }

    private Function<K, Entry<V>> toEntry(Function<K, V> underlying) {
        return key -> new Entry(underlying.apply(key), 0L, this.clock);
    }

    private Entry<V> computeIfAbsent(K key) {
        Entry<V> tmp;
        Entry<V> v = this.map.get(key);
        if (v == null && (v = this.map.putIfAbsent(key, tmp = this.entryGetter.apply(key))) == null) {
            v = tmp;
        }
        return v;
    }

    public V get(K key) {
        Entry<V> entry = this.computeIfAbsent(key);
        return (V)((Entry)entry).getValue();
    }

    public List<V> values() {
        Collection<Entry<V>> values = this.map.values();
        List res = values.stream().map(e -> ((Entry)e).value).collect(Collectors.toList());
        return Collections.unmodifiableList(res);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return "ExpiringCache{map=" + this.map + ", expireAfterMs=" + this.expireAfterMs + '}';
    }

    private static final class Entry<V> {
        private volatile long accessTime;
        private final V value;
        private final Clock clock;

        private Entry(V value, long accessTime, Clock clock) {
            this.value = value;
            this.accessTime = accessTime;
            this.clock = clock;
        }

        private V getValue() {
            this.accessTime = this.clock.now();
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.accessTime == entry.accessTime && this.value.equals(entry.value);
        }

        public int hashCode() {
            int result = (int)(this.accessTime ^ this.accessTime >>> 32);
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "Entry{accessTime=" + this.accessTime + ", value=" + this.value + '}';
        }
    }
}

