/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.api.common.exception;

import feign.FeignException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Pattern PATTERN_FEIGN = Pattern.compile("^.*; content:[\\r|\\n]*(.*)$");
    @Autowired
    private Environment environment;

    @ExceptionHandler(value={BindException.class, HttpMessageNotReadableException.class, MethodArgumentNotValidException.class, MissingServletRequestParameterException.class, MissingServletRequestPartException.class, TypeMismatchException.class, IllegalStateException.class, UnsupportedOperationException.class, HttpRequestMethodNotSupportedException.class, HttpMediaTypeNotAcceptableException.class, HttpMediaTypeNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Object handleBadRequestException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        return ResponseEntity.badRequest().body((Object)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Object handleOtherException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        if (activeProfiles.contains("dev") || activeProfiles.contains("test")) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)StringUtils.defaultString((String)e.getMessage(), (String)"\u540e\u53f0\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\uff01"));
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"\u54cd\u5e94\u5931\u8d25");
    }

    @ExceptionHandler(value={FeignException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Object handleFeignException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        String message = null;
        Matcher matcher = PATTERN_FEIGN.matcher(e.getMessage());
        message = matcher.find() ? matcher.group(1) : e.getMessage();
        return ResponseEntity.badRequest().body((Object)message);
    }
}

