/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.api.controller;

import com.bxm.adxcounter.api.common.enums.AdxMtCountEnum;
import com.bxm.adxcounter.api.common.handle.AdxHandle;
import com.bxm.adxcounter.api.controller.HelperBaseController;
import com.bxm.adxcounter.facade.model.AdxCounterDTO;
import com.bxm.adxcounter.facade.service.AdxCounterService;
import com.bxm.warcar.web.util.Encrypted;
import com.bxm.warcar.web.util.EncryptedMessage;
import com.bxm.warcar.web.util.TextFormat;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adx"})
public class AdxCounterController
extends HelperBaseController {
    private static final Logger log = LoggerFactory.getLogger(AdxCounterController.class);
    @Resource
    private AdxCounterService adxCounterService;

    @RequestMapping(value={"/countInfo"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    public ResponseEntity countInfo(AdxCounterDTO counter, HttpServletRequest request) {
        return this.countInfo0(counter, request);
    }

    @Encrypted(model=AdxCounterDTO.class, plaintextFormat=TextFormat.PARAMS)
    @RequestMapping(value={"/dot/countInfo"}, method={RequestMethod.GET})
    @CrossOrigin(origins={"*"})
    public ResponseEntity countInfoDES(EncryptedMessage<AdxCounterDTO> message, HttpServletRequest request) {
        AdxCounterDTO counter = (AdxCounterDTO)message.getObject();
        return this.countInfo0(counter, request);
    }

    private ResponseEntity countInfo0(AdxCounterDTO counter, HttpServletRequest request) {
        AdxMtCountEnum mtCountEnum = AdxMtCountEnum.of(counter.getMt());
        if (AdxMtCountEnum._OTHER == mtCountEnum) {
            return ResponseEntity.badRequest().body((Object)"mt\u4e0d\u5339\u914d");
        }
        counter.setMt(mtCountEnum.getMt().getOriginal());
        AdxHandle.handleParam(counter);
        this.handle(counter, request);
        return this.adxCounterService.counter(counter);
    }
}

