/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adxcounter.api.controller;

import com.bxm.adxcounter.api.common.enums.SdkMtCountEnum;
import com.bxm.adxcounter.api.controller.HelperBaseController;
import com.bxm.adxcounter.facade.model.SdkCounterDTO;
import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.facade.model.SdkErrorDTO;
import com.bxm.adxcounter.facade.model.SdkPublicDTO;
import com.bxm.adxcounter.facade.service.SdkService;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.web.util.Encrypted;
import com.bxm.warcar.web.util.EncryptedMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sdk"})
public class SdkCounterController
extends HelperBaseController {
    private static final Logger log = LoggerFactory.getLogger(SdkCounterController.class);
    @Resource
    private SdkService sdkService;

    @RequestMapping(value={"/init"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    public ResponseEntity init(@RequestBody SdkEquipmentDTO counter, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)counter.getIp())) {
            counter.setIp(IpHelper.getIpFromHeader((HttpServletRequest)request));
        }
        counter.setTimestamp(System.currentTimeMillis());
        if (Objects.equals(counter.getOs(), 1) && !StringHelper.isNewVersion((String)"2.4.0", (String)counter.getSdkv())) {
            String devb = counter.getDevm();
            String devm = counter.getDevb();
            counter.setDevb(devb);
            counter.setDevm(devm);
        }
        return this.sdkService.init(counter);
    }

    @RequestMapping(value={"/dot/init"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    @Encrypted(model=SdkEquipmentDTO.class, encryptResponseEntity=true)
    public ResponseEntity initDES(@RequestBody EncryptedMessage<SdkEquipmentDTO> message, HttpServletRequest request) {
        SdkEquipmentDTO counter = (SdkEquipmentDTO)message.getObject();
        if (StringUtils.isBlank((CharSequence)counter.getIp())) {
            counter.setIp(IpHelper.getIpFromHeader((HttpServletRequest)request));
        }
        counter.setTimestamp(System.currentTimeMillis());
        return this.sdkService.init(counter);
    }

    @RequestMapping(value={"/ext_bind"}, method={RequestMethod.POST})
    public ResponseEntity<Objects> extBind(@RequestBody SdkPublicDTO sdkPublicDTO) {
        try {
            this.sdkService.extBind(sdkPublicDTO);
            return ResponseEntity.ok().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @RequestMapping(value={"/dot/ext_bind"}, method={RequestMethod.POST})
    @Encrypted(model=SdkPublicDTO.class, encryptResponseEntity=true)
    public ResponseEntity<Objects> extBindDES(@RequestBody EncryptedMessage<SdkPublicDTO> message) {
        SdkPublicDTO sdkPublicDTO = (SdkPublicDTO)message.getObject();
        try {
            this.sdkService.extBind(sdkPublicDTO);
            return ResponseEntity.ok().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @RequestMapping(value={"/error"}, method={RequestMethod.POST})
    public ResponseEntity error(@RequestBody SdkErrorDTO sdkErrorDTO) {
        log.error("sdkErrorDTO={}", (Object)sdkErrorDTO);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/dot/error"}, method={RequestMethod.POST})
    @Encrypted(model=SdkErrorDTO.class, encryptResponseEntity=true)
    public ResponseEntity errorDES(@RequestBody EncryptedMessage<SdkErrorDTO> message) {
        log.error("sdkErrorDTO={}", message.getObject());
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/batchCountInfo"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    public ResponseEntity batchCountInfo(@RequestBody List<SdkCounterDTO> counterList, HttpServletRequest request) {
        if (CollectionUtils.isEmpty(counterList)) {
            return ResponseEntity.badRequest().body((Object)"\u4e0a\u62a5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SdkCounterDTO counter : counterList) {
            SdkMtCountEnum mtCountEnum = SdkMtCountEnum.of(counter.getMt());
            if (SdkMtCountEnum._OTHER == mtCountEnum) continue;
            if (StringUtils.isBlank((CharSequence)counter.getIp())) {
                counter.setIp(IpHelper.getIpFromHeader((HttpServletRequest)request));
            }
            counter.setMt(mtCountEnum.getMt().getOriginal());
            this.sdkService.counter(counter);
        }
        return ResponseEntity.ok().build();
    }

    @RequestMapping(value={"/dot/countInfo"}, method={RequestMethod.POST})
    @Encrypted(model=SdkCounterDTO.class, encryptResponseEntity=true)
    public ResponseEntity countInfoDES(@RequestBody EncryptedMessage<SdkCounterDTO> message, HttpServletRequest request) {
        SdkCounterDTO counter = (SdkCounterDTO)message.getObject();
        SdkMtCountEnum mtCountEnum = SdkMtCountEnum.of(counter.getMt());
        if (SdkMtCountEnum._OTHER == mtCountEnum) {
            return ResponseEntity.badRequest().body((Object)"mt\u4e0d\u5339\u914d");
        }
        if (StringUtils.isBlank((CharSequence)counter.getIp())) {
            counter.setIp(IpHelper.getIpFromHeader((HttpServletRequest)request));
        }
        counter.setMt(mtCountEnum.getMt().getOriginal());
        this.sdkService.counter(counter);
        return ResponseEntity.ok().build();
    }
}

