#!/bin/bash

if [ ! -f ~/run/adxcounter-api.pid ]; then
  echo "Server [adxcounter-api] doest not started!"
  exit
fi

pid=`cat ~/run/adxcounter-api.pid`
if [ ! -n "${pid}" ]; then
  echo "illegal content in adxcounter-api.pid!"
  exit
fi

process=`ps -aux|awk '{print $2}' | grep ${pid}`
if [ -n "${process}" ]; then
  echo "Server [adxcounter-api] will be stop."
  kill ${pid}

  times=0
  while true
  do
    process=`ps -aux|awk '{print $2}' | grep ${pid}`
    if [ -n "${process}" ] && [ ${times} -lt 10 ]; then
      let times++
      sleep 1
    else
      break
    fi
  done

  process=`ps -aux|awk '{print $2}' | grep ${pid}`
  if [ -n "${process}" ]; then
    echo "Server [adxcounter-api] cannot stop, Please check pid file 'adxcounter-api.pid' and stop it by manually!"
    exit
  fi
else
  echo "Server [adxcounter-api] has been stoped!"
fi

rm -f ~/run/adxcounter-api.pid