package com.bxm.adxcounter.integration.mccms;

import javax.annotation.Resource;

import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import com.bxm.mccms.facade.service.ITaskFacadeService;

import lombok.extern.slf4j.Slf4j;

/**
 * <p>
 * 任务 远程调用服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-30
 */
@Slf4j
@Service
public class TaskIntegration {

    @Resource
    private ITaskFacadeService taskFacadeService;

    /**
     * 更改任务状态
     * @param taskId
     * @param status
     * @param pauseReason
     * @return
     */
    public Boolean updateStatus(Long taskId, Integer status, Integer pauseReason) {
        ResponseEntity<Boolean> resultModel = taskFacadeService.updateStatus(taskId, status, pauseReason);
        if (HttpStatus.OK.equals(resultModel.getStatusCode())) {
            return resultModel.getBody();
        }
        log.error("开发者后台异常，更改任务状态失败！-->{}", resultModel.getStatusCodeValue());
        return Boolean.FALSE;

    }


}
