package com.bxm.adxcounter.integration.user;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.model.SdkPublicDTO;
import com.bxm.user.facade.DevRequest;
import com.bxm.user.facade.SdkInitCache;
import com.bxm.user.facade.UserProfile;
import com.bxm.user.facade.service.UserService;

import lombok.extern.slf4j.Slf4j;

/**
 * 用户信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/9/23 10:55
 */
@Slf4j
@Service
public class UserIntegration {

    @Resource
    private UserService userService;


    /**
     * 获取uid<br/>
     *
     * @param request
     * @return java.lang.String
     */
    public String getUid(DevRequest request) {
        UserProfile user = userService.getUser(request);
        if(null == user){
            return null;
        }
        return user.getUid();
    }
    /**
     * 获取uid<br/>
     *
     * @param sdk
     * @return java.lang.String
     */
    public String getUid(SdkPublicDTO sdk){
        return getUid(DevRequest.builder()
                .os(sdk.getOs())
                .imei(sdk.getImei())
                .imeiMd5(sdk.getImei_md5())
                .anid(sdk.getAnid())
                .anidMd5(sdk.getAnid_md5())
                .oaid(sdk.getOaid())
                .idfa(sdk.getIdfa())
                .idfaMd5(sdk.getIdfa_md5())
                .build());
    }

    /**
     * 获取SDK初始化信息<br/>
     *
     * @param request
     * @return java.lang.String
     */
    public SdkInitCache getSdkInit(DevRequest request){
        return userService.getSdkInit(request);
    }
}
