package com.bxm.adxcounter.service.common.autoconfigure;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.bxm.adxcounter.service.common.autoconfigure.config.ApplicationGlobalConfig;
import com.bxm.adxcounter.service.common.autoconfigure.config.DataCenterConfig;
import com.bxm.warcar.integration.autoconfigure.dc.dot.DotProperties;
import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.integration.dc.dot.Dot;
import com.bxm.warcar.integration.dc.dot.impl.DefaultDotImpl;
import com.bxm.warcar.integration.dc.dot.impl.ThreadPoolExecutorDotImpl;

/**
 * 数据中心打点<br/>
 *
 * @author kerry.jiang
 * @date 2020/2/26 18:51
 */
@Configuration
public class DataCenterDotConfiguration {

    private DataCenterConfig dataCenterConfig;
    @Autowired
    private DotProperties dotProperties;
    
    public DataCenterDotConfiguration(ApplicationGlobalConfig config){
        this.dataCenterConfig = config.getDc();
    }

    /**
     * SDK<br/>
     */
    @Bean
    public AsyncDot asyncDotSdk() {
        Dot dot = new DefaultDotImpl(dataCenterConfig.getDotSdkUrl());
        DotProperties.ThreadPoolProperties threadPool = dotProperties.getThreadPool();
        return new ThreadPoolExecutorDotImpl(dot, threadPool.getPoolCoreSize(),
                threadPool.getAwaitTerminationTimeInSeconds());
    }
}
