package com.bxm.adxcounter.service.common.handle;

import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.model.endpoint.AbstractEndpoint;

/**
 * 处理辅助类<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/31 20:48
 */
public class AdxEndpointHandle {

    /**
     * 获取设备号
     * @param endpoint
     * @return
     */
    public static String getUid(UserIntegration userIntegration, AbstractEndpoint endpoint){
        return userIntegration.getUid(DevRequest.builder()
                .osStr(endpoint.getOs())
                .imei(endpoint.getImei())
                .anid(endpoint.getAndroidId())
                .idfa(endpoint.getIdfa())
                .build());
    }
}
