package com.bxm.adxcounter.service.common.transfer;


import java.nio.charset.StandardCharsets;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.lang3.StringUtils;

/**
 * 赢价解密<br/>
 * @author kerry.jiang fgf
 * @date 2020/1/16 16:00
 */
public class AdxDecrypt {
    
    private static final String KEY_ALGORITHM  = "AES";
    
    /**
     * 加密<br/>
     *
     * @param content 明文内容
     * @param key 密钥
     * @return
     * @throws
     */
    public static String encrypt(String content, String key) throws Exception {
        if (StringUtils.isBlank(content) || StringUtils.isBlank(key)) {
            return null;
        }
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec sKey = new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, sKey);
        // 进行 AES 加密
        byte[] result = cipher.doFinal(byteContent);
        // 将 byte 数组转为十六进制的字符串
        return parseByte2HexStr(result);
    }
    
    /**
     * 解密<br/>
     *
     * @param encryptContent 待解密内容
     * @param key 密钥
     * @return
     * @throws
     */
    public static String decrypt(String encryptContent, String key) throws Exception {
        // 将十六进制的加密文本转换为 byte 数组
        byte[] content = parseHexStr2Byte(encryptContent);
        if (content == null) {
            return null;
        }
        SecretKeySpec sKey = new SecretKeySpec(key.getBytes(), KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(Cipher.DECRYPT_MODE, sKey);
        byte[] result = cipher.doFinal(content);
        // 将二进制转为字符串
        return new String(result);
    }
    
    /**
     * 将 byte 数组转换成 16 进制的字符串
     *
     * @param buf
     * @return 16 进制的字符串
     */
    private static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; i++) {
            //将每个字节都转成 16 进制的
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                //为保证格式统一，用两位 16 进制的表示一个字节
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }
    
    /**
     * 将 16 进制的字符串转换为 byte 数组
     *
     * @param hexStr
     * @return byte 数组
     */
    private static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int num = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 2), 16);
            result[i] = (byte) num;
        }
        return result;
    }
}
