package com.bxm.adxcounter.service.common.transfer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import com.bxm.adxcounter.facade.model.TaskCounterDTO;
import com.bxm.adxcounter.service.model.endpoint.TaskEndpoint;

import lombok.extern.slf4j.Slf4j;

/**
 * 转换器-耍呗任务<br/>
 *
 * @author kerry.jiang
 * @date 2020/6/2 16:28
 */
@Slf4j
@Configuration
public class TaskConvert {

    @Autowired
    private SdkConvert sdkConvert;
    
    /**
     * 参数转换<br/>
     * ADX-耍呗任务<br/>
     *
     * @param  endpoint
     * @param  counter
     */
    public void of(TaskEndpoint endpoint, TaskCounterDTO counter){
        endpoint.of(counter);
        endpoint.setBxmBidId(counter.getBidid());
        endpoint.setAppId(counter.getAppid());
        endpoint.setPositionId(counter.getTagid());
        endpoint.setDspId(counter.getDspid());
        endpoint.setTaskId(counter.getTaskid());

        //填充SDK初始化参数
        sdkConvert.fillSdkInitInfo(endpoint, counter);
    }
}
