package com.bxm.adxcounter.service.listeners;

import javax.annotation.Resource;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.facade.model.SdkEquipmentDTO;
import com.bxm.adxcounter.service.model.endpoint.SdkEndpoint;
import com.bxm.warcar.integration.dc.dot.AsyncDot;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.utils.JsonHelper;

import lombok.extern.slf4j.Slf4j;

/**
 * 埋点超类-SDK<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 15:53
 */
@Slf4j
public class SdkDotSupport {
    
    /**
     * 如果这个ip无法得到国家编码，默认一个无效的编码
     */
    private static final String DEF_COUNTRY_CODE = "00";
    /**
     * 如果这个ip无法得到行政编码，默认一个无效的编码
     */
    private static final String DEF_CITY_CODE = "000000";

    @Resource(name = "asyncDotSdk")
    private AsyncDot asyncDot;
    
    /**
     * 初始化上报<br/>
     */
    public void consume(SdkEquipmentDTO endpoint, IP ip) {
        Map<String, Object> parameter = new HashMap<>();
        parameter.put("mt", DotMtEnum._16005.getDotMt());//数据中心埋点值
        parameter.put("t", endpoint.getTimestamp());//请求时间戳
        parameter.put("ip", endpoint.getIp());//用户IP
        parameter.put("mac", endpoint.getMac());//mac地址
        parameter.put("os", endpoint.getOs());//操作系统
        parameter.put("osv", endpoint.getOsv());//系统版本号
        parameter.put("imei", endpoint.getImei());//imei
        parameter.put("imei_md5", endpoint.getImei_md5());//imei_md5
        parameter.put("anid", endpoint.getAnid());//android id
        parameter.put("anid_md5", endpoint.getAnid_md5());//android id md5
        parameter.put("oaid", endpoint.getOaid());//安全联盟定义的用户唯一标识OAID
        parameter.put("idfa", endpoint.getIdfa());//idfa
        parameter.put("idfa_md5", endpoint.getIdfa_md5());//idfa_md5
        parameter.put("devid", endpoint.getDevid());//设备id
        parameter.put("devb", endpoint.getDevb());//设备品牌
        parameter.put("devm", endpoint.getDevm());//设备型号,如:华为 mate 10 pro
        parameter.put("devt", endpoint.getDevt());//设备类型,1:手机, 2:平板
        parameter.put("devsh", endpoint.getDevsh());//设备屏幕高度
        parameter.put("devsw", endpoint.getDevsw());//设备屏幕宽度
        parameter.put("memory", endpoint.getMemory());//内存,单位:G
        parameter.put("storage", endpoint.getStorage());//存储空间,单位:G
        parameter.put("cpum", endpoint.getCpum());//cpu型号
        parameter.put("isp", endpoint.getIsp());//网络运营商
        parameter.put("net", endpoint.getNet());//联网方式,0:未知, 1:以太网, 2:WIFI, 3:2G, 4:3G, 5:4G, 6:5G
        parameter.put("lon", endpoint.getLon());//经度
        parameter.put("lat", endpoint.getLat());//纬度
        parameter.put("sdkv", endpoint.getSdkv());//sdk版本号
        parameter.put("appl", endpoint.getAppl());//本机应用列表
        parameter.put("pkn", endpoint.getPkn());//app包名
        parameter.put("appid", endpoint.getAppid());//变现猫appid(Code)
        if(null != ip){
            String regionCode = StringUtils.defaultIfEmpty(ip.getRegioncode(), DEF_CITY_CODE);
            parameter.put("country", StringUtils.defaultIfEmpty(ip.getCountrycode(), DEF_COUNTRY_CODE));//国家
            parameter.put("province", getProvinceCode(regionCode));//省
            parameter.put("city", regionCode);//市
        }
        asyncDot.asyncDotPostForm(parameter);
    }

    /**
     * 所属省级代码
     */
    private String getProvinceCode(String regionCode) {
        return StringUtils.rightPad(StringUtils.left(regionCode, 2), 6, "0");
    }

    /**
     * 埋点<br/>
     */
    public void consume(DotMtEnum[] dotMtEnums, SdkEndpoint endpoint) {
        if(dotMtEnums.length > 1){
            for (DotMtEnum dotMtEnum: dotMtEnums) {
                asyncDotGet(dotMtEnum, endpoint);
            }
        }else{
            asyncDotGet(dotMtEnums[0], endpoint);
        }
    }

    private void asyncDotGet(DotMtEnum dotMtEnum, SdkEndpoint endpoint) {
        if (dotMtEnum == DotMtEnum._OTHER) {
            // unknown model type, so ignore.
            return;
        }

        Map<String, Object> parameter = new HashMap<>();
        parameter.put("mt", dotMtEnum.getDotMt());//数据中心埋点值
        parameter.put("t", endpoint.getTimestamp());//请求时间戳
        parameter.put("os", endpoint.getOs());//操作系统
        parameter.put("sdkv", endpoint.getSdkVersion());//sdk版本号
        parameter.put("imei", endpoint.getImei());//imei
        parameter.put("idfa", endpoint.getIdfa());//idfa
        parameter.put("ip", endpoint.getIp());//用户IP
        parameter.put("ua", endpoint.getUa());//User-Agent
        parameter.put("posid", endpoint.getPositionId());//广告位id
        parameter.put("code", endpoint.getErrorCode());//错误代码
        parameter.put("tcode", endpoint.getThirdErrorCode());//第三方错误代码
        parameter.put("type", endpoint.getThirdSdkType());//第三方SDK类型
        
        if(log.isDebugEnabled()){
            log.debug("dot:{}", JsonHelper.convert(parameter));
        }
        asyncDot.asyncDotPostForm(parameter);
    }
}
