package com.bxm.adxcounter.service.listeners.adx;

import org.springframework.stereotype.Service;

import com.bxm.adxcounter.facade.constant.DotMtEnum;
import com.bxm.adxcounter.integration.adx.UserIntegration;
import com.bxm.adxcounter.service.common.handle.AdxEndpointHandle;
import com.bxm.adxcounter.service.model.endpoint.AdxEndpoint;
import com.bxm.adxcounter.service.model.events.adx.AdxGeneralEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * @author allen
 * @date 2020-10-29
 * @since 1.0
 */
@Service
public class ShowStatisticsEventListener implements EventListener<AdxGeneralEvent> {

    private final Counter counter;
    private final UserIntegration userIntegration;

    public ShowStatisticsEventListener(Counter counter, UserIntegration userIntegration) {
        this.counter = counter;
        this.userIntegration = userIntegration;
    }

    @Override
    @Subscribe
    public void consume(AdxGeneralEvent event) {
        AdxEndpoint endpoint = event.getEndpoint();
        DotMtEnum[] dotMtEnums = event.getDotMtEnums();
        for (DotMtEnum dotMtEnum : dotMtEnums) {
            if (dotMtEnum == DotMtEnum._15005) {
                handleWithPerDay(endpoint);
                handleWithUid(endpoint);
            }
        }
    }

    private void handleWithPerDay(AdxEndpoint endpoint) {
        String positionId = endpoint.getPositionId();
        String dspId = endpoint.getDspId();

        KeyGenerator key = () -> KeyBuilder.build("statistics", "adx", "show", DateHelper.getDate(), positionId);

        counter.hincrementAndGet(key, dspId);
    }

    private void handleWithUid(AdxEndpoint endpoint) {
        String positionId = endpoint.getPositionId();
        String dspId = endpoint.getDspId();

        String uid = AdxEndpointHandle.getUid(userIntegration, endpoint);

        KeyGenerator key = () -> KeyBuilder.build("statistics", "adx", "show", DateHelper.getDate(), positionId, dspId, uid);

        counter.incrementAndGet(key, 24 * 60 * 60);
    }
}
