package com.bxm.adxcounter.service.listeners.sdk;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bxm.adxcounter.service.listeners.SdkDotSupport;
import com.bxm.adxcounter.service.model.events.sdk.SdkEquipmentEvent;
import com.bxm.adxcounter.service.service.IpService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import lombok.extern.slf4j.Slf4j;

/**
 * SDK埋点-初始化<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/24 16:11
 */
@Slf4j
@Service
public class SdkEquipmentDotEventListener extends SdkDotSupport implements EventListener<SdkEquipmentEvent> {

    @Autowired
    private IpService ipService;
    
    @Override
    @Subscribe
    public void consume(SdkEquipmentEvent event) {
        String ip = event.getEndpoint().getIp();
        if(StringUtils.isNotBlank(ip)){
            super.consume(event.getEndpoint(), ipService.analyze(ip));
        }else{
            super.consume(event.getEndpoint(), null);
        }
    }
}
